<?php

	header("Access-Control-Allow-Origin: *");

	include("conn.php");
	
	if(!isset($_GET["cp"]) || !isset($_GET["product"])){
		echo json_encode([
			"status" => false
		]);
		exit();
	}
	
	if($_GET["cp"] == "" || !in_array($_GET["product"],["syncol","eternal","kanka"]) ){
		echo json_encode([
			"status" => false
		]);
		exit();
	}
	
	$response = geocode("{$_GET["cp"]}, México.");
	
	if($response){
		
		$km_limit = 2;
		$branches_return = [];
		$myLat = $response[0];
		$myLng = $response[1];
		
		#$myLat = "19.435528";
		#$myLng = "-99.129470";
		
		$db->where("LATITUD_GEOGRAFICA",null," IS NOT");
		$db->where("LONGITUD_GEOGRAFICA",null," IS NOT");
		$branches = $db->get($_GET["product"]);
		
		foreach($branches as $branch){
			
			$distance_between_points = (vincentyGreatCircleDistance($myLat,$myLng,$branch["LATITUD_GEOGRAFICA"],$branch["LONGITUD_GEOGRAFICA"]) / 1000);
			#array_push($branches_return,$distance_between_points);
			
			if($distance_between_points  < $km_limit){
				array_push($branches_return,$branch);
			}

		}
		
		echo json_encode([
			"status" => true,
			"result" => $branches_return
		]);
		
		
		
	}else{
		echo json_encode([
			"status" => false
		]);
		exit();
	}

	function geocode($address){
	 
		// url encode the address
		$address = urlencode($address);
		 
		// google map geocode api url
		$url = "https://maps.googleapis.com/maps/api/geocode/json?address={$address}&key=AIzaSyDitmphNqu9jWMCkrA_CRYAP7KH13RmutQ";
		
		#echo "{$url}\n";
	 
		// get the json response
		$resp_json = file_get_contents($url);
		 
		// decode the json
		$resp = json_decode($resp_json, true);
	 
		// response status will be 'OK', if able to geocode given address 
		if($resp['status']=='OK'){
	 
			// get the important data
			$lati = isset($resp['results'][0]['geometry']['location']['lat']) ? $resp['results'][0]['geometry']['location']['lat'] : "";
			$longi = isset($resp['results'][0]['geometry']['location']['lng']) ? $resp['results'][0]['geometry']['location']['lng'] : "";
			$formatted_address = isset($resp['results'][0]['formatted_address']) ? $resp['results'][0]['formatted_address'] : "";
			 
			// verify if data is complete
			if($lati && $longi && $formatted_address){
			 
				// put the data in the array
				$data_arr = array();
				 
				array_push(
					$data_arr, 
						$lati, 
						$longi, 
						$formatted_address
					);
				 
				return $data_arr;
				 
			}else{
				return false;
			}
			 
		}
	 
		else{
			#echo "<strong>ERROR: {$resp['status']}</strong>\n";
			return false;
		}
	}
	
	/**
		https://stackoverflow.com/a/10054282/2708938
	 * Calculates the great-circle distance between two points, with
	 * the Vincenty formula.
	 * @param float $latitudeFrom Latitude of start point in [deg decimal]
	 * @param float $longitudeFrom Longitude of start point in [deg decimal]
	 * @param float $latitudeTo Latitude of target point in [deg decimal]
	 * @param float $longitudeTo Longitude of target point in [deg decimal]
	 * @param float $earthRadius Mean earth radius in [m]
	 * @return float Distance between points in [m] (same as earthRadius)
	 */
	function vincentyGreatCircleDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000){
	  // convert from degrees to radians
	  $latFrom = deg2rad($latitudeFrom);
	  $lonFrom = deg2rad($longitudeFrom);
	  $latTo = deg2rad($latitudeTo);
	  $lonTo = deg2rad($longitudeTo);

	  $lonDelta = $lonTo - $lonFrom;
	  $a = pow(cos($latTo) * sin($lonDelta), 2) +
		pow(cos($latFrom) * sin($latTo) - sin($latFrom) * cos($latTo) * cos($lonDelta), 2);
	  $b = sin($latFrom) * sin($latTo) + cos($latFrom) * cos($latTo) * cos($lonDelta);

	  $angle = atan2(sqrt($a), $b);
	  return $angle * $earthRadius;
	}


?>