var map;
var markers = [];
var openMarker = null;

function initMap() {
	window.map = new google.maps.Map(document.getElementById('map'),{
		center: {lat: 19.4326, lng: -99.1332},
		zoom: 15
	});
}
function searchBranches(){

	var cp = document.getElementById("cp").value;
	
	if(cp == ""){
		return false;
	}
	
	jQuery.get("https://sourcecodeapps.com/mapa_farmacias/searchBranches.php?cp="+cp+"&product="+window.product,function(response){
		console.log(response);
		var response = JSON.parse(response);
		
		if(response.status){
			window.clearMarkers();
			window.addMarkers(response.result);
		}else{
			alert("No se encontró ningun resultado");
		}
		
	});
	
}

function clearMarkers(){
	for(var i = 0; i < window.markers.length; i++){
		window.markers[i].setMap(null);
	}
	window.markers = [];
}

function addMarkers(_markers){
	for(var i = 0; i < _markers.length; i++){
		
		var contentString = '<div>'+
		'<h1 style="font-size:14px; font-weight:bold; color:#000;">'+_markers[i].FARMACIA+'</h1>'+
		'<p style="color:#000;">'+_markers[i].CALLE_NUMERO+', '+_markers[i].COLONIA+', '+_markers[i].POBLACION+', '+_markers[i].ESTADO+', '+' '+_markers[i].CODIGO_POSTAL+'.</p>' +
		'<p style="color:#000;"><a href="https://www.google.com/maps/search/'+_markers[i].LATITUD_GEOGRAFICA+','+_markers[i].LONGITUD_GEOGRAFICA+'" target="_blank">Como llegar</a></p>' +
		'</div>';

		var infowindow = new google.maps.InfoWindow({
			content: contentString
		});
		
		var myLatLng = {lat: parseFloat(_markers[i].LATITUD_GEOGRAFICA), lng: parseFloat(_markers[i].LONGITUD_GEOGRAFICA)};

		var marker = new google.maps.Marker({
			position: myLatLng,
			map:window.map,
			title: _markers[i].FARMACIA
		});
		
		marker.infowindow = infowindow;
		
		marker.addListener('click', function() {
			if(window.openMarker !== null){
				window.openMarker.infowindow.close();
			}
			this.infowindow.open(window.map,this);
			window.openMarker = this;
		});
		
		window.markers.push(marker);
	}
	
	window.centerMap();
	
}

function centerMap(){
	
	var bounds = new google.maps.LatLngBounds();
	var infowindow = new google.maps.InfoWindow();    

	for (i = 0; i < window.markers.length; i++){
		bounds.extend(window.markers[i].position);
	}

	window.map.fitBounds(bounds);

}